<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

# constructor

Init the form by providing the element, it can be either HTML selector or the form element (HTMLFormElement).

**Parameters**

-   `el` **([string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String) \| [HTMLFormElement](https://developer.mozilla.org/en-US/docs/Web/API/HTMLFormElement))** 
-   `options` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** Options
    -   `options.responseType` **\[[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)]** Define the response type, eg. `json`(default), `blob`, `arraybuffer`, leave empty if undefined
    -   `options.headers` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** Define custom headers

**Examples**

```javascript
ajaxable('form.ajaxable', {
 responseType: '',
 headers: {
   'Content-Type': 'text/html; charset=UTF-8'
 }
});
```

# onStart

Bind a callback and execute it on start of each request
The callback accepts parameters object as argument

**Parameters**

-   `clb` **[Function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function)** Callback function

**Examples**

```javascript
ajaxable('...').onStart((params) => {
 // do stuff
})
```

# onEnd

Bind a callback and execute it on end of each request
The callback accepts parameters object as argument

**Parameters**

-   `clb` **[Function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function)** Callback function

**Examples**

```javascript
ajaxable('...').onEnd((params) => {
 // do stuff
})
```

# onResponse

Bind a callback and execute it on response of each request
The callback accepts the response and parameters as arguments

**Parameters**

-   `clb` **[Function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function)** Callback function

**Examples**

```javascript
ajaxable('...').onResponse((res, params) => {
 // do stuff
})
```

# onError

Bind a callback and execute it on error of each request
The callback accepts the error and parameters as arguments

**Parameters**

-   `clb` **[Function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function)** Callback function

**Examples**

```javascript
ajaxable('...').onError((err, params) => {
 // do stuff
})
```

# submit

Submit the request

**Examples**

```javascript
ajaxable('...').submit();
```
