<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// The version number (9_5_0) should match version of the Chilkat extension used, omitting the micro-version number.
// For example, if using Chilkat v9.5.0.48, then include as shown here:
include("chilkat_9_5_0.php");

// This example requires the Chilkat API to have been previously unlocked.
// See Global Unlock Sample for sample code.

$bounce = new CkBounce();

// The mailman object is used for receiving (POP3) 
// and sending (SMTP) email.
$mailman = new CkMailMan();

// Set the POP3 server's hostname
$mailman->put_MailHost('mail.themailchecker.com');

// Set the POP3 login/password.
$mailman->put_PopUsername('admin@themailchecker.com');
$mailman->put_PopPassword('Icert123#A');

// Copy the all email from the user's POP3 mailbox 
// into a bundle object.  The email remains on the server.
// (There are other methods for deleting email from a POP3 server.)
// bundle is a CkEmailBundle
$bundle = $mailman->CopyMail();
if ($mailman->get_LastMethodSuccess() == false) {
    print $mailman->lastErrorText() . "\n";
    exit;
}

$i = 0;

while ($i < $bundle->get_MessageCount()) {
    // email is a CkEmail
    $email = $bundle->GetEmail($i);

    $success = $bounce->ExamineEmail($email);
    if ($success == false) {
        print $bounce->lastErrorText() . "\n";

        exit;
    }

    if ($bounce->get_BounceType() == 1) {
        // Hard bounce, log the email address
        print 'Hard Bounce: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 2) {
        // Soft bounce, log the email address
        print 'Soft Bounce: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 3) {
        // General bounce, no email address available.
        print 'General Bounce: No email address' . "\n";
    }

    if ($bounce->get_BounceType() == 4) {
        // General bounce, log the email address
        print 'General Bounce: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 5) {
        // Mail blocked, log the email address
        // A bounce occured because the sender was blocked. 
        print 'Mail Blocked: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 6) {
        // Auto-reply, log the email address
        print 'Auto-Reply: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 7) {
        // Transient (recoverable) Failure, log the email address
        print 'Transient Failure: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 8) {
        // Subscribe request, log the email address
        print 'Subscribe Request: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 9) {
        // Unsubscribe Request, log the email address
        print 'Unsubscribe Request: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 10) {
        // Virus Notification, log the email address
        print 'Virus Notification: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 11) {
        // Suspected bounce.
        // This should be rare.  It indicates that the Bounce
        // component found strong evidence that this is a bounced
        // email, but couldn't quite recognize everything it
        // needed to be 100% sure.  Feel free to notify
        // support@chilkatsoft.com regarding emails having this
        // bounce type.
        print 'Suspected Bounce!' . "\n";
    }

    if ($bounce->get_BounceType() == 12) {
        // Challenge/Response - Auto-reply message sent by SPAM software 
        // where only verified email addresses are accepted. 
        print 'Challenge: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 13) {
        // Address Change Notification Message.
        print 'Address Change: ' . $bounce->bounceAddress() . "\n";
    }

    if ($bounce->get_BounceType() == 14) {
        // Success DSN indicating that the message was successfully relayed.
        print 'DSN Successful Relay: ' . "\n";
    }

    $i = $i + 1;
}

$success = $mailman->Pop3EndSession();

?>